<?php
include("../includes/DbConnect.php");
$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];

// Retrieve Cash Deposit and calculate total by item and currencySymbol
$cashDepositsQuery = $dbConn->prepare("SELECT * FROM cashdeposit WHERE depositDate BETWEEN :startDate AND :endDate GROUP BY id");
$cashDepositsQuery->execute(array(':startDate' => $startDate, ':endDate' => $endDate));
$result1 = $cashDepositsQuery->fetchAll(PDO::FETCH_ASSOC);

// Initialize total variables for each currency symbol
$totalByCurrency = array();

foreach ($result1 as $row) {
    $currencySymbol = $row['currencySymbol'];

    // Initialize total for this currency if not already set
    if (!isset($totalByCurrency[$currencySymbol])) {
        $totalByCurrency[$currencySymbol] = 0;
    }

    // Add the current row's total to the corresponding currency total
    $totalByCurrency[$currencySymbol] += $row['depositAmount'];
}
?>

<table>
    <tr>
        <th>FOLIO NUMBER</th>
        <th>CURRENCY SYMBOL</th>
        <th>TOTAL</th>
    </tr>

    <?php foreach ($result1 as $row) : ?>
        <tr>
            <td><?php echo $row['folioNumber']; ?></td>
            <td><?php echo $row['currencySymbol']; ?></td>
            <td><?php echo $row['depositAmount']; ?></td>
        </tr>
    <?php endforeach; ?>

    <?php foreach ($totalByCurrency as $currencySymbol => $depositAmount) : ?>
        <tr>
            <th colspan="2">TOTAL <?php echo $currencySymbol; ?></th>
            <th><?php echo $depositAmount; ?></th>
        </tr>
    <?php endforeach; ?>
</table>