<?php
include("../includes/DbConnect.php");
$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];

// Retrieve sales data using prepared statements
$salesQuery = "SELECT SUM(totalAmount) AS total_sales, currencySymbol FROM tblsales WHERE saleDate BETWEEN :startDate AND :endDate GROUP BY currencySymbol";
$salesStmt = $dbConn->prepare($salesQuery);
$salesStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$salesData = $salesStmt->fetchAll(PDO::FETCH_ASSOC);

// Retrieve returns data using prepared statements
$returnsQuery = "SELECT SUM(totalAmount) AS total_returns, currencySymbol FROM tbreturn_purchases WHERE returnDate BETWEEN :startDate AND :endDate GROUP BY currencySymbol";
$returnsStmt = $dbConn->prepare($returnsQuery);
$returnsStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$returnsData = $returnsStmt->fetchAll(PDO::FETCH_ASSOC);

// Retrieve discount data using prepared statements
$discountQuery = "SELECT SUM(discount) AS total_invoice_discount, currencySymbol FROM tblinvoices WHERE invoiceStatus = 1 AND invoiceDate BETWEEN :startDate AND :endDate GROUP BY currencySymbol";
$discountStmt = $dbConn->prepare($discountQuery);
$discountStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$discountData = $discountStmt->fetchAll(PDO::FETCH_ASSOC);

// Retrieve cost of goods sold data using prepared statements
$costOfGoodsQuery = "SELECT SUM(si.cost_price) AS total_cost_of_goods, s.currencySymbol 
                     FROM tblsale_items si
                     JOIN tblsales s ON si.sale_id = s.id
                     WHERE s.saleDate BETWEEN :startDate AND :endDate 
                     GROUP BY s.currencySymbol";
$costOfGoodsStmt = $dbConn->prepare($costOfGoodsQuery);
$costOfGoodsStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$costOfGoodsData = $costOfGoodsStmt->fetchAll(PDO::FETCH_ASSOC);

// Retrieve bills data using prepared statements
$billsQuery = $dbConn->prepare("SELECT billType, SUM(amount) AS total_amount, currencySymbol FROM paymentbills WHERE paymentDate BETWEEN :startDate AND :endDate GROUP BY billType, currencySymbol");
$billsQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$billsData = $billsQuery->fetchAll();

// Retrieve salaries data using prepared statements
// Retrieve salaries data using prepared statements
$salariesQuery = $dbConn->prepare("SELECT salaryAmount, currencySymbol FROM paymentsalaries WHERE salaryDate BETWEEN :startDate AND :endDate");
$salariesQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$salariesData = $salariesQuery->fetchAll();

// Retrieve issued stock data using prepared statements
$issueStockQuery = "SELECT SUM(cost_price) AS total_issued_stock, currencySymbol FROM tbfinished_products_dispatch WHERE dispatchDate BETWEEN :startDate AND :endDate GROUP BY currencySymbol";
$issueStockStmt = $dbConn->prepare($issueStockQuery);
$issueStockStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$issueStockData = $issueStockStmt->fetchAll(PDO::FETCH_ASSOC);

// Retrieve tax amount data using prepared statements
$taxAmountQuery = "SELECT SUM(tax) AS total_invoice_tax, currencySymbol FROM tblinvoices WHERE invoiceStatus = 1 AND invoiceDate BETWEEN :startDate AND :endDate GROUP BY currencySymbol";
$taxAmountStmt = $dbConn->prepare($taxAmountQuery);
$taxAmountStmt->execute(['startDate' => $startDate, 'endDate' => $endDate]);
$taxAmountData = $taxAmountStmt->fetchAll(PDO::FETCH_ASSOC);

// Calculate total sales
$totalSales = 0;
foreach($salesData as $sale) {
    $totalSales += $sale['total_sales'];
}

// Calculate total returns
$totalReturns = 0;
foreach($returnsData as $return) {
    $totalReturns += $return['total_returns'];
}

// Calculate net sales
$netSales = $totalSales - $totalReturns;

// Calculate total invoice discount
$totalInvoiceDiscount = 0;
foreach($discountData as $discount) {
    $totalInvoiceDiscount += $discount['total_invoice_discount'];
}

// Calculate gross sales
$grossSales = $totalSales + $totalInvoiceDiscount;

// Calculate cost of goods sold
$totalCostOfGoods = 0;
foreach($costOfGoodsData as $cost) {
    $totalCostOfGoods += $cost['total_cost_of_goods'];
}

// Calculate gross profit
$grossProfit = $grossSales - $totalCostOfGoods;

// Calculate total bills
// Calculate total bills
$totalBills = 0;
foreach ($billsData as $bill) {
    $totalBills += $bill['total_amount'];
}

// Calculate total salaries
$totalSalaries = 0;
foreach ($salariesData as $salary) {
    $totalSalaries += $salary['salaryAmount'];
}

// Calculate net income before taxes
$netIncomeBeforeTaxes = $grossProfit - $totalBills - $totalSalaries;

// Calculate total issued stock
$totalIssuedStock = 0;
foreach($issueStockData as $stock) {
    $totalIssuedStock += $stock['total_issued_stock'];
}

// Calculate net income before taxes and inventory adjustment
$netIncomeBeforeTaxesAndInvAdj = $netIncomeBeforeTaxes + $totalCostOfGoods - $totalIssuedStock;

// Calculate total tax amount
$totalTaxAmount = 0;
foreach($taxAmountData as $tax) {
    $totalTaxAmount += $tax['total_invoice_tax'];
}

// Calculate net income after taxes
$netIncomeAfterTaxes = $netIncomeBeforeTaxesAndInvAdj - $totalTaxAmount;

// Output the income statement
echo '<table>';
echo '<tr><th></th><th>Amount</th><th>Currency</th></tr>';

if (empty($salesData)) {
    $totalSales = '0.00';
}

if (empty($returnsData)) {
    $totalReturns = '0.00';
}

if (empty($discountData)) {
    $totalInvoiceDiscount = '0.00';
}

if (empty($costOfGoodsData)) {
    $totalCostOfGoods = '0.00';
}

if (empty($billsData)) {
    $totalBills = '0.00';
}

if (empty($salariesData)) {
    $totalSalaries = '0.00';
}

if (empty($issueStockData)) {
    $totalIssuedStock = '0.00';
}

if (empty($taxAmountData)) {
    $totalTaxAmount = '0.00';
}

echo '<tr><td>Sales</td><td>' . $totalSales . '</td><td>' . ($salesData[0]['currencySymbol'] ?? '') . '</td></tr>';
echo '<tr><td>Returns</td><td>' . $totalReturns . '</td><td>' . ($returnsData[0]['currencySymbol'] ?? '') . '</td></tr>';
echo '<tr><th>Net Sales</th><th>' . $netSales . '</th><th>' . ($salesData[0]['currencySymbol'] ?? '') . '</th></tr>';
echo '<tr><td>Invoice Discount</td><td>' . $totalInvoiceDiscount . '</td><td>' . ($discountData[0]['currencySymbol'] ?? '') . '</td></tr>';
echo '<tr><th>Gross Sales</th><th>' . $grossSales . '</th><th>' . ($salesData[0]['currencySymbol'] ?? '') . '</th></tr>';
echo '<tr><td>Cost of Goods Sold</td><td>' . $totalCostOfGoods . '</td><td>' . ($costOfGoodsData[0]['currencySymbol'] ?? '') . '</td></tr>';
echo '<tr><th>Gross Profit</th><th>' . $grossProfit . '</th><th>' . ($salesData[0]['currencySymbol'] ?? '') . '</th></tr>';
echo '<tr><td>Bills</td><td>' . $totalBills . '</td><td>' . ($billsData[0]['currencySymbol'] ?? '') . '</td></tr>';
echo '<tr><td>Salaries</td><td>' . $totalSalaries . '</td><td>' . ($salariesData[0]['currencySymbol'] ?? '') . '</td></tr>';
echo '<tr><th>Net Income Before Taxes</th><th>' . $netIncomeBeforeTaxes . '</th><th>' . ($salesData[0]['currencySymbol'] ?? '') . '</th></tr>';
echo '<tr><td>Issued Stock</td><td>' . $totalIssuedStock . '</td><td>' . ($issueStockData[0]['currencySymbol'] ?? '') . '</td></tr>';
echo '<tr><th>Net Income Before Taxes and Inventory Adjustment</th><th>' . $netIncomeBeforeTaxesAndInvAdj . '</th><th>' . ($salesData[0]['currencySymbol'] ?? '') . '</th></tr>';
echo '<tr><td>Taxes</td><td>' . $totalTaxAmount . '</td><td>' . ($taxAmountData[0]['currencySymbol'] ?? '') . '</td></tr>';
echo '<tr><th>Net Income After Taxes</th><th>' . $netIncomeAfterTaxes . '</th><th>' . ($salesData[0]['currencySymbol'] ?? '') . '</th></tr>';

echo '</table>';
