const quantityInput = document.getElementById('quantity');
const unitPriceInput = document.getElementById('unitPrice');
const taxInput = document.getElementById('tax');
const amountInput = document.getElementById('amount');

quantityInput.addEventListener('input', calculateAmount);
unitPriceInput.addEventListener('input', calculateAmount);
taxInput.addEventListener('input', calculateAmount);

function calculateAmount() {

  const quantity = parseFloat(quantityInput.value) || 0;
  const unitPrice = parseFloat(unitPriceInput.value) || 0;
  const tax = parseFloat(taxInput.value) || 0;

  const amount = (quantity * unitPrice) + ((quantity * unitPrice * tax) / 100);

  amountInput.value = amount.toFixed(2);
}