document.addEventListener('DOMContentLoaded', function () {
    let convertBtn = document.querySelector('#saveSellingResportPDFButton');
    if (convertBtn) {
        convertBtn.addEventListener('click', function() {
            let element = document.querySelector('#stockAtSellingReport');
            let itemName = document.querySelector('#itemNameSelling').value;
            let pdfName = 'Stock at Selling Price Report - ' + itemName + '.pdf';

            let buttons = document.querySelectorAll('.pdf-buttons');
            if (buttons) {
                buttons.forEach(button => button.style.display = 'none');
            }

            html2canvas(element, { useCORS: true, background: true }).then(canvas => {

                let imgWidth = 210;
                let pageHeight = 295;
                let imgHeight = Math.floor(canvas.height * imgWidth / canvas.width);
                let heightLeft = imgHeight;

                const contentDataURL = canvas.toDataURL('image/png');
                let pdf = new jsPDF('p', 'mm', 'a4');
                let position = 0;

                pdf.addImage(contentDataURL, 'PNG', 0, position, imgWidth, imgHeight);

                pdf.save(pdfName);

                if (buttons) {
                    buttons.forEach(button => button.style.display = 'block');
                }

            });
        });
    } else {
        console.log("Button not found");
    }
});