<?php 
	class Reconciliation {

		public $id;
		public $accountName;
		public $currency;
		public $newStatementBalance;
		public $source;
		public $cheaqueNumber;
		public $description;
		public $rate;
		public $debit;
		public $credit;
		public $reconcile;
        public $bankChargies;
		public $reconcileDate;

		public $tableName = 'bank_reconciliation';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function reconcile() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET accountName = :accountName, currency = :currency, newStatementBalance = :newStatementBalance, source = :source, cheaqueNumber = :cheaqueNumber, description = :description, rate = :rate, debit = :debit, credit = :credit, reconcile = :reconcile, bankChargies = :bankChargies, reconcileDate = :reconcileDate';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->accountName = htmlspecialchars(strip_tags($this->accountName));
          	$this->currency = htmlspecialchars(strip_tags($this->currency));
          	$this->newStatementBalance = htmlspecialchars(strip_tags($this->newStatementBalance));
          	$this->source = htmlspecialchars(strip_tags($this->source));
          	$this->cheaqueNumber = htmlspecialchars(strip_tags($this->cheaqueNumber));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->rate = htmlspecialchars(strip_tags($this->rate));
               $this->debit = htmlspecialchars(strip_tags($this->debit));
          	$this->credit = htmlspecialchars(strip_tags($this->credit));
          	$this->reconcile = htmlspecialchars(strip_tags($this->reconcile));
               $this->bankChargies = htmlspecialchars(strip_tags($this->bankChargies));
          	$this->reconcileDate = htmlspecialchars(strip_tags($this->reconcileDate));

          	// Bind data
          	$myStatement->bindParam(':accountName', $this->accountName);
          	$myStatement->bindParam(':currency', $this->currency);
          	$myStatement->bindParam(':newStatementBalance', $this->newStatementBalance);
          	$myStatement->bindParam(':source', $this->source);
          	$myStatement->bindParam(':cheaqueNumber', $this->cheaqueNumber);
          	$myStatement->bindParam(':description', $this->description);
          	$myStatement->bindParam(':rate', $this->rate);
          	$myStatement->bindParam(':debit', $this->debit);
          	$myStatement->bindParam(':credit', $this->credit);
            $myStatement->bindParam(':reconcile', $this->reconcile);
            $myStatement->bindParam(':bankChargies', $this->bankChargies);
          	$myStatement->bindParam(':reconcileDate', $this->reconcileDate);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>