<?php 
	class JobCosting {

		public $id;
          public $item;
          public $description;
		public $productionCost;
		public $markup;
		public $tax;
		public $amount;

		public $tableName = 'jobcosting';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addNewRecord() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET item = :item, description = :description, productionCost = :productionCost, markup = :markup, tax = :tax, amount = :amount';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->productionCost = htmlspecialchars(strip_tags($this->productionCost));
          	$this->markup = htmlspecialchars(strip_tags($this->markup));
          	$this->tax = htmlspecialchars(strip_tags($this->tax));
          	$this->amount = htmlspecialchars(strip_tags($this->amount));

          	// Bind data
          	$myStatement->bindParam(':item', $this->item);
          	$myStatement->bindParam(':description', $this->description);
          	$myStatement->bindParam(':productionCost', $this->productionCost);
          	$myStatement->bindParam(':markup', $this->markup);
          	$myStatement->bindParam(':tax', $this->tax);
          	$myStatement->bindParam(':amount', $this->amount);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>