<?php 
	class PaymentsBills {

		public $id;
        public $paymentMode;
        public $currency;
		public $billType;
		public $branch;
		public $accountName;
		public $accountNumber;
        public $amount;
		public $memo;
		public $paymentDate;

		public $tableName = 'paymentbills';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addBill() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET paymentMode = :paymentMode, currency = :currency, billType = :billType, branch = :branch, accountName = :accountName, accountNumber = :accountNumber, amount = :amount, memo = :memo, paymentDate = :paymentDate';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->paymentMode = htmlspecialchars(strip_tags($this->paymentMode));
          	$this->currency = htmlspecialchars(strip_tags($this->currency));
          	$this->billType = htmlspecialchars(strip_tags($this->billType));
          	$this->branch = htmlspecialchars(strip_tags($this->branch));
          	$this->accountName = htmlspecialchars(strip_tags($this->accountName));
          	$this->accountNumber = htmlspecialchars(strip_tags($this->accountNumber));
          	$this->amount = htmlspecialchars(strip_tags($this->amount));
          	$this->memo = htmlspecialchars(strip_tags($this->memo));
          	$this->paymentDate = htmlspecialchars(strip_tags($this->paymentDate));

          	// Bind data
          	$myStatement->bindParam(':paymentMode', $this->paymentMode);
          	$myStatement->bindParam(':currency', $this->currency);
          	$myStatement->bindParam(':billType', $this->billType);
          	$myStatement->bindParam(':branch', $this->branch);
          	$myStatement->bindParam(':accountName', $this->accountName);
          	$myStatement->bindParam(':accountNumber', $this->accountNumber);
          	$myStatement->bindParam(':amount', $this->amount);
          	$myStatement->bindParam(':memo', $this->memo);
          	$myStatement->bindParam(':paymentDate', $this->paymentDate);

			if($myStatement->execute()) {
				$accountNumber = $this->accountNumber;
				$this->updateAccountBalance($accountNumber, $this->amount);
				return true;
			} else {
				return false;
			}
		}
		private function updateAccountBalance($accountNumber, $amount) {
			$query = 'UPDATE openaccounts SET openingBalance = openingBalance - :amount WHERE accountNumber = :accountNumber';
	
			$stmt = $this->dbConn->prepare($query);
			$stmt->bindParam(':amount', $amount);
			$stmt->bindParam(':accountNumber', $accountNumber);
			$stmt->execute();
		}

	}
 ?>