<?php 
	class DispatchProducts {

		public $dispatchDate;
		public $item;
		public $serialNumber;
		public $description;
		public $color;
		public $size;
		public $quantity;
		public $cost_price;
		public $dispatchedTo;

		public $tableName = 'tbfinished_products_dispatch';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function dispatchProducts() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET dispatchDate = :dispatchDate, serialNumber = :serialNumber, item = :item, description = :description, color = :color, size = :size, quantity = :quantity, cost_price = :cost_price, dispatchedTo = :dispatchedTo';

          	$myStatement = $this->dbConn->prepare($query);

          	$this->dispatchDate = htmlspecialchars(strip_tags($this->dispatchDate));
          	$this->serialNumber = htmlspecialchars(strip_tags($this->serialNumber));
			$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->color = htmlspecialchars(strip_tags($this->color));
          	$this->size = htmlspecialchars(strip_tags($this->size));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
			$this->cost_price = htmlspecialchars(strip_tags($this->cost_price));
          	$this->dispatchedTo = htmlspecialchars(strip_tags($this->dispatchedTo));

          	$myStatement->bindParam(':dispatchDate', $this->dispatchDate);
          	$myStatement->bindParam(':serialNumber', $this->serailNumber);
			$myStatement->bindParam(':item', $this->item);
          	$myStatement->bindParam(':description', $this->description);
          	$myStatement->bindParam(':color', $this->color);
          	$myStatement->bindParam(':size', $this->size);
          	$myStatement->bindParam(':quantity', $this->quantity);
			$myStatement->bindParam(':cost_price', $this->cost_price);
          	$myStatement->bindParam(':dispatchedTo', $this->dispatchedTo);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>