<?php 
	class CashDeposit {

		public $id;
        public $depositDate;
		public $branch;
        public $folioNumber;
		public $accountNumber;
		public $depositAmount;
		public $currencySymbol;
		public $chartOfAccount;

		public $tableName = 'cashdeposit';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addNewRecord() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET depositDate = :depositDate, branch = :branch, folioNumber = :folioNumber, accountNumber = :accountNumber, depositAmount = :depositAmount, currencySymbol = :currencySymbol, chartOfAccount = :chartOfAccount';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->depositDate= htmlspecialchars(strip_tags($this->depositDate));
			$this->branch = htmlspecialchars(strip_tags($this->branch));
          	$this->folioNumber = htmlspecialchars(strip_tags($this->folioNumber));
          	$this->accountNumber = htmlspecialchars(strip_tags($this->accountNumber));
          	$this->depositAmount = htmlspecialchars(strip_tags($this->depositAmount));
          	$this->currencySymbol = htmlspecialchars(strip_tags($this->currencySymbol));
          	$this->chartOfAccount = htmlspecialchars(strip_tags($this->chartOfAccount));

          	// Bind data
          	$myStatement->bindParam(':depositDate', $this->depositDate);
			$myStatement->bindParam(':branch', $this->branch);
          	$myStatement->bindParam(':folioNumber', $this->folioNumber);
          	$myStatement->bindParam(':accountNumber', $this->accountNumber);
          	$myStatement->bindParam(':depositAmount', $this->depositAmount);
          	$myStatement->bindParam(':currencySymbol', $this->currencySymbol);
          	$myStatement->bindParam(':chartOfAccount', $this->chartOfAccount);

			if($myStatement->execute()) {
				$accountNumber = $this->accountNumber;
				$this->updateAccountBalance($accountNumber, $this->depositAmount);
				return true;
			} else {
				return false;
			}
		}
		private function updateAccountBalance($accountNumber, $depositAmount) {
			$query = 'UPDATE openaccounts SET openingBalance = openingBalance + :depositAmount WHERE accountNumber = :accountNumber';
	
			$stmt = $this->dbConn->prepare($query);
			$stmt->bindParam(':depositAmount', $depositAmount);
			$stmt->bindParam(':accountNumber', $accountNumber);
			$stmt->execute();
		}

	}
 ?>