<?php 
	class Invoice {

		public $id;
		public $invoiceNumber;
		public $dueDate;
		public $invoiceStatus;
		public $coyName;
		public $coyEmail;
		public $coyPhone;
		public $coyAddress;
		public $customerName;
		public $customerEmail;
		public $customerPhone;
		public $customerAddress;
		public $item;
		public $description;
		public $quantity;
		public $price;
		public $amount;
		public $discount;
		public $tax;
		public $total;

		public $tableName = 'tblinvoices';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addInvoice() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET invoiceNumber = :invoiceNumber, dueDate = :dueDate, invoiceStatus = :invoiceStatus, coyName = :coyName, coyEmail = :coyEmail, coyPhone = :coyPhone, coyAddress = :coyAddress, customerName = :customerName, customerEmail = :customerEmail, customerPhone = :customerPhone, customerAddress = :customerAddress, item = :item, description = :description, quantity = :quantity, price = :price, amount = :amount, discount = :discount, tax = :tax, total = :total';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->invoiceNumber = htmlspecialchars(strip_tags($this->invoiceNumber));
          	$this->dueDate = htmlspecialchars(strip_tags($this->dueDate));
          	$this->invoiceStatus = htmlspecialchars(strip_tags($this->invoiceStatus));
          	$this->coyName = htmlspecialchars(strip_tags($this->coyName));
          	$this->coyEmail = htmlspecialchars(strip_tags($this->coyEmail));
          	$this->coyPhone = htmlspecialchars(strip_tags($this->coyPhone));
          	$this->coyAddress = htmlspecialchars(strip_tags($this->coyAddress));
          	$this->customerName = htmlspecialchars(strip_tags($this->customerName));
          	$this->customerEmail = htmlspecialchars(strip_tags($this->customerEmail));
          	$this->customerPhone = htmlspecialchars(strip_tags($this->customerPhone));
          	$this->customerAddress = htmlspecialchars(strip_tags($this->customerAddress));
          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
          	$this->price = htmlspecialchars(strip_tags($this->price));
          	$this->amount = htmlspecialchars(strip_tags($this->amount));
          	$this->discount = htmlspecialchars(strip_tags($this->discount));
          	$this->tax = htmlspecialchars(strip_tags($this->tax));
          	$this->total = htmlspecialchars(strip_tags($this->total));

          	// Bind data
          	$myStatement->bindParam(':invoiceNumber', $this->invoiceNumber);
          	$myStatement->bindParam(':dueDate', $this->dueDate);
          	$myStatement->bindParam(':invoiceStatus', $this->invoiceStatus);
          	$myStatement->bindParam(':coyName', $this->coyName);
          	$myStatement->bindParam(':coyEmail', $this->coyEmail);
          	$myStatement->bindParam(':coyPhone', $this->coyPhone);
          	$myStatement->bindParam(':coyAddress', $this->coyAddress);
          	$myStatement->bindParam(':customerName', $this->customerName);
          	$myStatement->bindParam(':customerEmail', $this->customerEmail);
          	$myStatement->bindParam(':customerPhone', $this->customerPhone);
          	$myStatement->bindParam(':customerEmail', $this->customerEmail);
          	$myStatement->bindParam(':customerAddress', $this->customerAddress);
          	$myStatement->bindParam(':item', $this->item);
			$myStatement->bindParam(':description', $this->description);
			$myStatement->bindParam(':quantity', $this->quantity);
			$myStatement->bindParam(':price', $this->price);
			$myStatement->bindParam(':amount', $this->amount);
			$myStatement->bindParam(':discount', $this->discount);
			$myStatement->bindParam(':tax', $this->tax);
			$myStatement->bindParam(':total', $this->total);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>