<?php

$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];


    // Fetch data from Purchase Orders table
    $purchasesOrdersQuery = $pdo->prepare("SELECT item, SUM(amount) as total FROM purchase_orders WHERE date BETWEEN :startDate AND :endDate GROUP BY item");
    $purchasesOrdersQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
    $result1 = $purchasesOrdersQuery->fetchAll();

    // Fetch data from Bills table
    $billsQuery = $pdo->prepare("SELECT item, SUM(amount) as total FROM bills WHERE date BETWEEN :startDate AND :endDate GROUP BY item");
    $billsQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
    $result2 = $billsQuery->fetchAll();

    // Fetch data from Salaries table
    $salariesQuery = $pdo->prepare("SELECT employee_name, amount FROM salaries WHERE date BETWEEN :startDate AND :endDate");
    $salariesQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
    $result3 = $salariesQuery->fetchAll();

    // Fetch data from Job Costing table
    $jobCostingQuery = $pdo->prepare("SELECT job_name, SUM(amount) as total FROM job_costing WHERE date BETWEEN :startDate AND :endDate GROUP BY job_name");
    $jobCostingQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
    $result4 = $jobCostingQuery->fetchAll();

    // Fetch data from Cash Deposit table
    $cashDepositQuery = $pdo->prepare("SELECT bank_name, SUM(amount) as total FROM cash_deposit WHERE date BETWEEN :startDate AND :endDate GROUP BY bank_name");
    $cashDepositQuery->execute(['startDate' => $startDate, 'endDate' => $endDate]);
    $result5 = $cashDepositQuery->fetchAll();

// Calculate the total purchases and expenses
$totalPurchases = 0;
foreach ($result1 as $row) {
    $totalPurchases += $row["total"];
}
$totalExpenses = 0;
foreach ($result2 as $row) {
    $totalExpenses += $row["total"];
}

// Calculate the net income
$netIncome = $totalPurchases - $totalExpenses;

// Create HTML table to display the balance sheet
echo "<table>
    <tr>
        <th>Assets</th>
        <th></th>
        <th>Liabilities and Equity</th>
        <th></th>
    </tr>";

// Display the total purchases under Assets
echo "<tr>
        <td>Total Purchases</td>
        <td>" . number_format($totalPurchases, 2) . "</td>
        <td>Liabilities</td>
        <td></td>
    </tr>";

// Display the total salaries paid under Assets
$totalSalaries = 0;
foreach ($result3 as $row) {
    $totalSalaries += $row["amount"];
}
echo "<tr>
        <td>Total Salaries</td>
        <td>" . number_format($totalSalaries, 2) . "</td>
        <td></td>
        <td></td>
    </tr>";

// Display the net income under Equity
echo "<tr>
        <td>Net Income</td>
        <td>" . number_format($netIncome, 2) . "</td>
        <td>Equity</td>
        <td></td>
    </tr>";

// Display the total cash deposits under Assets
$totalDeposits = 0;
foreach ($result5 as $row) {
    $totalDeposits += $row["total"];
}
echo "<tr>
        <td>Total Cash Deposits</td>
        <td>" . number_format($totalDeposits, 2) . "</td>
        <td></td>
        <td></td>
    </tr>";

echo "</table>";
