document.addEventListener('DOMContentLoaded', function () {
  let convertBtn = document.querySelector('#convertInvoiceToPDF');
  if (convertBtn) {
    convertBtn.addEventListener('click', function() {
      html2canvas(document.querySelector('#convertPreviewToPDF')).then((canvas) => {
        let base64image = canvas.toDataURL('image/png');
        let invoiceNumber = document.querySelector('#invoiceNumber').value;
        let pdfName = 'Invoice-' + invoiceNumber + '.pdf';
        
        let contentHeight = document.querySelector('#convertPreviewToPDF').offsetHeight;
        
        let pdf = new jsPDF('p', 'px', [1043.74, contentHeight]);
        
        pdf.addImage(base64image, 'PNG', 15, 15, 1043.74, contentHeight-30);
        
        pdf.save(pdfName);
      });
    });
  } else {
    console.log("Button not found");
  }
});
