$(document).ready(function() {

  // Submit form to generate report
  $('#generateNetprofitReport').submit(function(e) {
    e.preventDefault();
    
    // Get form data
    var start_date = $('#startDate').val();
    var end_date = $('#endDate').val();
    var cashierName = $('#cashierNameNetProfit').val();
    var currency_symbol = $('#currencyNetProfit').val();

    // Send AJAX request to PHP script
    $.ajax({
      type: 'POST',
      url: 'reports/get-net-profit.php',
      data: {
        startDate: start_date,
        endDate: end_date,
        cashierName: cashierName,
        currencySymbol: currency_symbol
      },
      dataType: 'json',
      success: function(data) {

        // Show sales items in table
        var html = '';
        $.each(data.sales_items, function(index, item) {
          html += '<tr>';
          html += '<td>' + (index + 1) + '</td>';
          html += '<td>' + item.itemName + '</td>';
          html += '<td>' + item.quantity + '</td>';
          html += '<td>' + item.total_price + '</td>';
          html += '</tr>';
        });
        $('#netProfitResults').html(html);

        // Show total amount, total cost and net profit
        $('#totalAmountNet').val(data.total_amount);
        $('#totalCost').val(data.total_cost);
        $('#netProfit').val(data.net_profit);

        // Enable Save to PDF button
        $('#saveTNetProfitoPDFButton').prop('disabled', false);
      }
    });
  });
})