<?php
include("../includes/DbConnect.php");
$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];

$quotationQuery = $dbConn->prepare("SELECT * FROM quotation WHERE created_on BETWEEN :startDate AND :endDate GROUP BY id");
$quotationQuery->bindParam(':startDate', $startDate);
$quotationQuery->bindParam(':endDate', $endDate);
$quotationQuery->execute();
$result1 = $quotationQuery->fetchAll();

$grandTotalsByCurrency = array();

?>

<table>
    <tr>
        <th>Date</th>
        <th>Quote Number</th>
        <th>Customer</th>
        <th></th>
        <th>Currency</th>

        <th>Amount</th>
    </tr>

    <?php foreach ($result1 as $row) : ?>
        <tr>
            <td><?php echo $row['created_on']; ?></td>
            <td><?php echo $row['quoteNumber']; ?></td>
            <td><?php echo $row['customerName']; ?></td>
            <td></td>
            <td><?php echo $row['currencySymbol']; ?></td>
           
            <td><?php echo $row['grandTotal']; ?></td>
        </tr>

        <?php
        preg_match('/[0-9,]+/', $row['grandTotal'], $matches);
        if (!empty($matches)) {
            $numericValue = str_replace(',', '', $matches[0]);

            $currencySymbol = $row['currencySymbol'];
            if (isset($grandTotalsByCurrency[$currencySymbol])) {
                $grandTotalsByCurrency[$currencySymbol] += (float) $numericValue;
            } else {
                $grandTotalsByCurrency[$currencySymbol] = (float) $numericValue;
            }
        }
        ?>

    <?php endforeach; ?>
    
    <?php foreach ($grandTotalsByCurrency as $currencySymbol => $totalAmount) : ?>
        <tr>
            <th colspan="5">TOTAL (<?php echo $currencySymbol; ?>)</th>

            <th><?php echo number_format($totalAmount); ?></th>
        </tr>
    <?php endforeach; ?>

</table>