<?php
include("../includes/DbConnect.php");
$startDate = $_POST['startDate'];
$endDate = $_POST['endDate'];

$receiptQuery = $dbConn->prepare("SELECT * FROM tblreceipts WHERE issueDate BETWEEN :startDate AND :endDate GROUP BY id");
$receiptQuery->bindParam(':startDate', $startDate);
$receiptQuery->bindParam(':endDate', $endDate);
$receiptQuery->execute();
$result1 = $receiptQuery->fetchAll();

$grandTotalsByCurrency = array();

?>

<table>
    <tr>
        <th>Date</th>
        <th>Receipt Number</th>
        <th>Customer Name </th>
        <th></th>
        <th>Currency</th>
        <th>Amount</th>
    </tr>

    <?php foreach ($result1 as $row) : ?>
        <tr>
            <td><?php echo $row['issueDate']; ?></td>
            <td><?php echo $row['receiptNumber']; ?></td>
            <td><?php echo $row['customerName']; ?></td>
            <td></td>
            <td><?php echo $row['currencySymbol']; ?></td>
            <td><?php echo $row['totalAmount']; ?></td>
        </tr>

        <?php
        preg_match('/[0-9,.]+/', $row['totalAmount'], $matches);
        if (!empty($matches)) {
            $numericValue = str_replace(',', '', $matches[0]);

            $currencySymbol = $row['currencySymbol'];
            if (isset($grandTotalsByCurrency[$currencySymbol])) {
                $grandTotalsByCurrency[$currencySymbol] += (float) $numericValue;
            } else {
                $grandTotalsByCurrency[$currencySymbol] = (float) $numericValue;
            }
        }
        ?>

    <?php endforeach; ?>
    
    <?php foreach ($grandTotalsByCurrency as $currencySymbol => $totalAmount) : ?>
        <tr>
            <th colspan="5">TOTAL (<?php echo $currencySymbol; ?>)</th>
            <th><?php echo number_format($totalAmount, 2, '.',); ?></th>
        </tr>
    <?php endforeach; ?>

</table>