<?php 
	class Currency {

		public $id;
        public $currencyName;
        public $currencyCountry;
		public $rate;
		public $currencySymbol;

		public $tableName = 'tblcurrencies';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addNewRecord() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET currencyName = :currencyName, currencyCountry = :currencyCountry, rate = :rate, currencySymbol = :currencySymbol';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->currencyName = htmlspecialchars(strip_tags($this->currencyName));
          	$this->currencyCountry = htmlspecialchars(strip_tags($this->currencyCountry));
          	$this->rate = htmlspecialchars(strip_tags($this->rate));
          	$this->currencySymbol = htmlspecialchars(strip_tags($this->currencySymbol));

          	// Bind data
          	$myStatement->bindParam(':currencyName', $this->currencyName);
          	$myStatement->bindParam(':currencyCountry', $this->currencyCountry);
          	$myStatement->bindParam(':rate', $this->rate);
          	$myStatement->bindParam(':currencySymbol', $this->currencySymbol);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>