<?php 
	class PaymentSalaries {

		public $id;
          public $employeeName;
          public $month;
		public $salaryAmount;
		public $extraTime;
		public $currency;
		public $paymentMode;
          public $branch;
		public $salaryDate;

		public $tableName = 'paymentsalaries';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addSalaryRecord() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET employeeName = :employeeName, month = :month, salaryAmount = :salaryAmount, extraTime = :extraTime, currency = :currency, paymentMode = :paymentMode, branch = :branch, salaryDate = :salaryDate';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->employeeName = htmlspecialchars(strip_tags($this->employeeName));
          	$this->month = htmlspecialchars(strip_tags($this->month));
          	$this->salaryAmount = htmlspecialchars(strip_tags($this->salaryAmount));
          	$this->extraTime = htmlspecialchars(strip_tags($this->extraTime));
          	$this->currency = htmlspecialchars(strip_tags($this->currency));
          	$this->paymentMode = htmlspecialchars(strip_tags($this->paymentMode));
          	$this->branch = htmlspecialchars(strip_tags($this->branch));
          	$this->salaryDate = htmlspecialchars(strip_tags($this->salaryDate));

          	// Bind data
          	$myStatement->bindParam(':employeeName', $this->employeeName);
          	$myStatement->bindParam(':month', $this->month);
          	$myStatement->bindParam(':salaryAmount', $this->salaryAmount);
          	$myStatement->bindParam(':extraTime', $this->extraTime);
          	$myStatement->bindParam(':currency', $this->currency);
          	$myStatement->bindParam(':paymentMode', $this->paymentMode);
          	$myStatement->bindParam(':branch', $this->branch);
          	$myStatement->bindParam(':salaryDate', $this->salaryDate);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>