<?php 
  // Headers
  header('Access-Control-Allow-Origin: *');
  header('Content-Type: application/json');
  header('Access-Control-Allow-Methods: POST');
  header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');

  include_once '../../config/DbConnect.php';
  include_once '../../functions/status_codes.php';
  include_once 'checklist.php';

  $database = new DbConnect();
  $db = $database->connect();

  // Instantiate Customer object
  $checklist = new Checklist($db);

  // Get raw data
  $data = json_decode(file_get_contents("php://input"));

  $checklist->serialNumber = $data->serialNumber;
  $checklist->product = $data->product;
  $checklist->description = $data->description;
  $checklist->size = $data->size;
  $checklist->quantity = $data->quantity;
  $checklist->fabric = $data->fabric;
  $checklist->buttons = $data->buttons;
  $checklist->zips = $zips;

  // Add Customer
  if($checklist->addToList()) {
    echo json_encode(
      array(['Status' => POST_SUCCESS, 'message' => 'New record was created Successfully...'])
    );
  } else {
    echo json_encode(
      array(['Status' => ERROR, 'message' => 'Something went wrong, contact admin for help'])
    );
  }

