document.addEventListener('DOMContentLoaded', function () {
    let convertBtn = document.querySelector('#saveDetailedReportPDF');
    if (convertBtn) {
        convertBtn.addEventListener('click', function() {
            let element = document.querySelector('#detailedSummary');
            let saleDate = document.querySelector('#saleDate').value;
            let pdfName = 'Detailed Report - ' + saleDate + '.pdf';

            html2canvas(element, { useCORS: true, background: true }).then(canvas => {

                let imgWidth = 210;
                let pageHeight = 295;
                let imgHeight = Math.floor(canvas.height * imgWidth / canvas.width);
                let heightLeft = imgHeight;

                const contentDataURL = canvas.toDataURL('image/png');
                let pdf = new jsPDF('p', 'mm', 'a4');
                let position = 0;

                pdf.addImage(contentDataURL, 'PNG', 0, position, imgWidth, imgHeight);
                heightLeft -= pageHeight;

                while (heightLeft >= 0) {
                    position = heightLeft - imgHeight;
                    pdf.addPage();
                    pdf.addImage(contentDataURL, 'PNG', 0, position, imgWidth, imgHeight);
                    heightLeft -= pageHeight;
                }

                pdf.save(pdfName);
            });
        });
    } else {
        console.log("Button not found");
    }
});