<?php
error_reporting(E_ALL);
include("../includes/DbConnect.php");

    // Get input values
    $startDate = $_POST['startDate'];
    $endDate = $_POST['endDate'];

    // Query to fetch stock value data between given dates
    $stmt = $dbConn->prepare("SELECT serialNumber, item, description, quantity, cost_price, (quantity*cost_price) as total_value FROM tbfinished_products_dispatch WHERE dispatchDate BETWEEN :startDate AND :endDate");
    $stmt->bindParam(':startDate', $startDate);
    $stmt->bindParam(':endDate', $endDate);
    $stmt->execute();
    $stockData = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Calculate total cost value
    $totalCostValue = 0;
    foreach ($stockData as $data) {
        $totalCostValue += $data['total_value'];
    }

    // Output results
    echo '<tbody id="dispatchedValueResults">';
    foreach ($stockData as $key => $data) {
        echo '<tr><td>'.($key+1).'</td><td>'.$data['serialNumber'].'</td><td>'.$data['item'].'</td><td>'.$data['description'].'</td><td>'.$data['quantity'].'</td><td>'.$data['cost_price'].'</td><td>'.$data['total_value'].'</td></tr>';
    }
    echo '</tbody></table>';

?>