document.addEventListener('DOMContentLoaded', () => {
    const form = document.getElementById('generateReceivedStockReport');
  
    form.addEventListener('submit', function(event) {
      event.preventDefault();
      const startDate = document.getElementById('startDate').value;
      const endDate = document.getElementById('endDate').value;
  
      fetch('stores-reports/get-received-stock.php', {
        method: 'POST',
        body: new URLSearchParams({
          startDate: startDate,
          endDate: endDate
        })
      })
      .then(response => response.text()) // Convert response to text format
      .then(data => {
        const receivedStockResults = document.getElementById('receivedStockResults');
        receivedStockResults.innerHTML = data;
  
        const saveTNetProfitoPDFButton = document.getElementById('saveTNetProfitoPDFButton');
        saveTNetProfitoPDFButton.disabled = false;
  
        // Set total amount value
        const htmlDoc = new DOMParser().parseFromString(data, 'text/html');
        const totalAmountElement = htmlDoc.querySelector('#totalAmount');
        if (totalAmountElement && !isNaN(parseFloat(totalAmountElement.textContent))) {
          const totalAmount = parseFloat(totalAmountElement.textContent);
          const totalAmountField = document.getElementById('totalAmount');
          totalAmountField.value = totalAmount;
        } else {
          // handle invalid input value
        }
        
      });   
    });       
  });