<?php 
	class DispatchProducts {

		public $dispatchDate;
		public $item;
		public $description;
		public $color;
		public $size;
		public $quantity;
		public $dispatchedTo;

		public $tableName = 'tbfinished_products_dispatch';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function dispatchProducts() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET dispatchDate = :dispatchDate, item = :item, description = :description, color = :color, size = :size, quantity = :quantity, dispatchedTo = :dispatchedTo';

          	$myStatement = $this->dbConn->prepare($query);

          	$this->dispatchDate = htmlspecialchars(strip_tags($this->dispatchDate));
          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->color = htmlspecialchars(strip_tags($this->color));
          	$this->size = htmlspecialchars(strip_tags($this->size));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
          	$this->dispatchedTo = htmlspecialchars(strip_tags($this->dispatchedTo));

          	$myStatement->bindParam(':dispatchDate', $this->dispatchDate);
          	$myStatement->bindParam(':item', $this->item);
          	$myStatement->bindParam(':description', $this->description);
          	$myStatement->bindParam(':color', $this->color);
          	$myStatement->bindParam(':size', $this->size);
          	$myStatement->bindParam(':quantity', $this->quantity);
          	$myStatement->bindParam(':dispatchedTo', $this->dispatchedTo);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>