<?php 
	class DispatchMaterials {

		public $dispatchDate;
		public $item;
		public $description;
		public $color;
		public $quantity;
		public $dispatchedTo;

		public $tableName = 'tbraw_materials_dispatch';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function dispatchRawMaterials() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET dispatchDate = :dispatchDate, item = :item, description = :description, color = :color, quantity = :quantity, dispatchedTo = :dispatchedTo';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->dispatchDate = htmlspecialchars(strip_tags($this->dispatchDate));
          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->color = htmlspecialchars(strip_tags($this->color));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
          	$this->dispatchedTo = htmlspecialchars(strip_tags($this->dispatchedTo));

          	// Bind data
          	$myStatement->bindParam(':dispatchDate', $this->dispatchDate);
          	$myStatement->bindParam(':item', $this->item);
          	$myStatement->bindParam(':description', $this->description);
          	$myStatement->bindParam(':color', $this->color);
          	$myStatement->bindParam(':quantity', $this->quantity);
          	$myStatement->bindParam(':dispatchedTo', $this->dispatchedTo);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>