function addReceiptRow () {
  var table = document.getElementById("receiptItem");
  var newRow = document.createElement("tr");
  newRow.innerHTML = `
    <td><input type="checkbox" class="itemRow custom-control-input" name="delete[]" id="itemRow_1"> <label class="custom-control-label" for="itemRow_1"></label></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="form-control" name="item_name[]" placeholder="Item" id="item"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="unit_price form-control" name="unit_price[]" placeholder="Price" id="unit_price"></div></div></div></td>
    <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="number" class="quantity form-control" name="quantity[]" id="quantity" placeholder="Quantity"></div></div></div></td>
  <td><div class="col-lg-12"><div class="row mb-3"><div class="col-sm-12"><input type="text" class="amount form-control" name="amount[]" id="amount" readonly=""></div></div></div></td>
  `;
  table.querySelector("tbody").appendChild(newRow);
}

function updateProduct(unit_price, quantity, amount) {
  if (!unit_price || !quantity || !amount) {
    return;
  }
  var priceValue = parseFloat(unit_price.value) || 0;
  var quantityValue = parseFloat(quantity.value) || 0;
  amount.value = (priceValue * quantityValue).toFixed(2);

  var table = document.getElementById("receiptItem");
  var allTotals = table.querySelectorAll(".amount");
  var totalAmount = 0;

  for (var i = 0; i < allTotals.length; i++) {
    var currentTotal = parseFloat(allTotals[i].value);
    if (!isNaN(currentTotal)) {
      totalAmount += currentTotal;
    }
  }
  var totalAmountField = document.getElementById("totalAmount");
  totalAmountField.value = totalAmount.toFixed(2);
  updateChange();
}

document.addEventListener("input", function (event) {
  var row = event.target.closest("tr");
  if (row) {
    var unit_price = row.querySelector(".unit_price");
    var quantity = row.querySelector(".quantity");
    var amount = row.querySelector(".amount");
    updateProduct(unit_price, quantity, amount);
  }
});


  function updateChange() {
    var totalAmount = document.getElementById("totalAmount").value;
    var amountPaid = document.getElementById("amountPaid").value;
    var balanceResult = totalAmount - amountPaid;
    document.getElementById("balanceResult").value = balanceResult.toFixed(2);
  }
  document.addEventListener("DOMContentLoaded", function() {
  // Add event listeners to the input fields
  document.getElementById("totalAmount").addEventListener("input", updateChange);
  document.getElementById("amountPaid").addEventListener("input", updateChange);
});

function deleteReceiptRows() {
  var table = document.getElementById("receiptItem");
  var checkboxes = table.querySelectorAll('input[type="checkbox"][name="delete[]"]');
  for (var i = checkboxes.length - 1; i >= 0; i--) {
    if (checkboxes[i].checked) {
      table.deleteRow(i + 1);
    }
  }
  var allTotals = table.querySelectorAll(".amount");
  var totalAmount = 0;

  for (var i = 0; i < allTotals.length; i++) {
    var currentTotal = parseFloat(allTotals[i].value);
    if (!isNaN(currentTotal)) {
      totalAmount += currentTotal;
    }
  }

  var totalAmountField = document.getElementById("totalAmount");
  totalAmountField.value = totalAmount.toFixed(2);
}

function convertCurrency() {
  const currencySymbol = document.getElementById("currencySymbol").value;
  const amountFields = document.querySelectorAll(".amount");
  const unit_price_fields = document.querySelectorAll(".unit_price");
  const quantity_fields = document.querySelectorAll(".quantity");

  fetch(`my_api/point-of-sale/currency-conveter-api.php?currencySymbol=${currencySymbol}&amount=1`)
    .then(res => res.json())
    .then(data => {
      const rate = data.rates[currencySymbol];

      Array.prototype.forEach.call(amountFields, function(amountField, index) {
        const amount = parseFloat(amountField.value.replace(/,/g, '')) || 0;
        const unit_price = parseFloat(unit_price_fields[index].value.replace(/,/g, '')) || 0;
        const quantity = parseFloat(quantity_fields[index].value.replace(/,/g, '')) || 0;

        const converted_total_amount = (rate * amount).toFixed(2);
        const converted_price = (rate * unit_price).toFixed(2);

        amountField.value = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2 }).format(converted_total_amount);
        unit_price_fields[index].value = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2 }).format(converted_price);

        updateProduct(unit_price_fields[index], quantity_fields[index], amountField);
      });

      var table = document.getElementById("receiptItem");
      var allTotalsConverted = table.querySelectorAll(".amount");
      var convertedGrandTotal = 0;

      for (var i = 0; i < allTotalsConverted.length; i++) {
        var currentTotal = parseFloat(allTotalsConverted[i].value.replace(/,/g, ''));
        if (!isNaN(currentTotal)) {
          var price = parseFloat(table.querySelectorAll(".unit_price")[i].value.replace(/,/g, '')) || 0;
          var quantityVal = parseFloat(table.querySelectorAll(".quantity")[i].value.replace(/,/g, '')) || 0;
          var convertedPrice = (rate * price).toFixed(2);
          var convertedAmount = (convertedPrice * quantityVal).toFixed(2);

          allTotalsConverted[i].value = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2 }).format(convertedAmount);
          convertedGrandTotal += parseFloat(convertedAmount);
        }
      }

      document.getElementById("totalAmount").value = new Intl.NumberFormat('en-US', { minimumFractionDigits: 2 }).format(convertedGrandTotal);

    });
}