<?php include_once 'includes/DbConnect.php';?>
<section class="section dashboard">
      <div class="row">

        <div class="col-lg-12">
          <div class="row">
          <div class="col-xl-5 col-md-5">
<?php
$branchName = $_SESSION['branchName'];

$query = "SELECT COUNT(*) AS total_customers FROM tblcustomers WHERE branchName = :branchName";
$statement = $dbConn->prepare($query);
$statement->bindParam(':branchName', $branchName);
$statement->execute();
$customerResult = $statement->fetch(PDO::FETCH_ASSOC);
$totalCustomers = $customerResult['total_customers'];
?>

<div class="col-xl-6 col-xl-12">
  <div class="card info-card sales-card">
    <div class="card-header bg-light">Total Customers</div>
    <div class="card-body">
      <p></p>
      <div class="d-flex align-items-center">
        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
          <i class="bi bi-people"></i>
        </div>
        <div class="ps-3">
          <h6><?php echo $totalCustomers; ?></h6>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="col-xl-5 col-xl-12">
                    
                        <div class="card info-card sales-card">
                            <div class="card-header bg-light">Bank Accounts</div>
                            <div class="card-body align-items-center">

                <table class="table">
<?php
$branchName = $_SESSION['branchName'];

$sql = "SELECT * FROM openaccounts WHERE branchName = :branchName";
$query = $dbConn->prepare($sql);
$query->bindParam(':branchName', $branchName); 
$query->execute();
$results = $query->fetchAll(PDO::FETCH_OBJ);

if (count($results) > 0) {
?>
    <table>
        <thead>
            <tr>
                <th scope="col">Account Name</th>
                <th scope="col">Account Number</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($results as $result) { ?>
                <tr>
                    <td><?php echo $result->accountName; ?></td>
                    <td><?php echo $result->accountNumber; ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
<?php } else { ?>
    <table>
        <tbody>
            <tr>
                <td colspan="2">
                    <center>
                        Yet to Add Bank Account(s)<br>
                        <a href="open-bank-account.php" style="font-size:10px;" class="btn btn-primary btn-sm">
                            <i class="bi bi-shield-plus me-1"></i> Add Bank Account
                        </a>
                    </center>
                </td>
            </tr>
        </tbody>
    </table>
<?php } ?>

                </div>

              </div>
            </div>                
              	
        </div>


            <div class="col-xl-6 col-xl-7">
                <div class="row">
                  <div class="col-xl-12 col-xl-12">
                    <div class="row">
                      <div class="col-xl-12 col-xl-12">
                        <div class="card info-card sales-card">
                            <div class="card-header bg-light">Total Receivables</div>
                            <div class="card-body align-items-center">
                                <div class="row">
                     <div class="col-lg-5">
    <h5 class="card-title" style="color: blue; font-weight:300; font-size: 13px;">CURRENT</h5>
    <div class="d-flex">
        <div class="ps-3">
        <?php
$branchName = $_SESSION['branchName'];

$query = "SELECT currencySymbol, SUM(total) AS total_receivables FROM tblinvoices WHERE invoiceStatus = 1 AND branchName = :branchName GROUP BY currencySymbol";
$myStatement = $dbConn->prepare($query);
$myStatement->bindParam(':branchName', $branchName);
$myStatement->execute();

$totalReceivables = array();
while ($row = $myStatement->fetch(PDO::FETCH_ASSOC)) {
    $currencySymbol = $row['currencySymbol'];
    $totalSum = $row['total_receivables'];
    $totalReceivables[$currencySymbol] = $totalSum;
}

echo '<div class="row">
<div class="col-lg-5"><select id="currencySelection" onchange="updateTotalAmount()">';
foreach ($totalReceivables as $currencySymbol => $totalSum) {
    echo '<option value="' . $currencySymbol . '">' . $currencySymbol . '</option>';
}
echo '</select></div>';

$defaultCurrency = 'USD';
$defaultTotalSum = isset($totalReceivables[$defaultCurrency]) ? $totalReceivables[$defaultCurrency] : 0;

echo '
<div class="col-lg-7"><h5 style="font-size:15px;"><span id="totalInvAmount">' . number_format((float)$defaultTotalSum, 2) . '</span></h5></div></div>';

echo '
<script>
    function updateTotalAmount() {
        var currencySelection = document.getElementById("currencySelection");
        var totalAmount = document.getElementById("totalInvAmount");
        var selectedCurrency = currencySelection.value;
        var selectedTotalSum = ' . json_encode($totalReceivables) . '[selectedCurrency];
        totalAmount.textContent =  (parseFloat(selectedTotalSum) || 0).toFixed(2);
    }
</script>';
?>
        </div>
    </div>
</div>

              <div class="col-lg-2"><br><br>
            <span style="border-right: 1px solid #000; height: 100px; padding: 20px;"></span>

          </div>


    <div class="col-lg-5 align-items-center">
    <h5 class="card-title" style="color: red; font-weight:300; font-size: 13px;">OVERDUE</h5>
    <div class="d-flex">
    <div class="ps-3">
    <?php
$branchName = $_SESSION['branchName']; 
$currentDate = date('Y-m-d');

$query = "SELECT currencySymbol, SUM(total) AS total_overdue FROM tblinvoices WHERE invoiceStatus = 0 AND dueDate < :currentDate AND branchName = :branchName GROUP BY currencySymbol";   

$stmt = $dbConn->prepare($query);
$stmt->bindParam(':currentDate', $currentDate);  
$stmt->bindParam(':branchName', $branchName);
$stmt->execute();

$currencyOptions = array();
while ($row = $stmt->fetch()) {
    $currencySymbol = $row['currencySymbol'];  
    $totalSum = $row['total_overdue'];
    
    $currencyOptions[$currencySymbol] = $totalSum;
}

echo '<div class="row">
<div class="col-lg-5"><select id="currencySelect" onchange="updateTotalAmount()">';

foreach ($currencyOptions as $currencySymbol => $totalSum) {
    echo '<option value="' . $currencySymbol . '">' . $currencySymbol . '</option>';
}

echo '</select></div>';

$usdTotal = 0;
if (isset($currencyOptions['USD'])) {
    $usdTotal =  $currencyOptions['USD'];  
}

echo '<div class="col-lg-7"><h5 style="font-size:15px;"><span id="totalAmount">' . number_format($usdTotal, 2) . '</span></h5></div>';

echo '</div>';

echo '
<script>
    function updateTotalAmount() {
        var currencySelect = document.getElementById("currencySelect");
        var totalAmount = document.getElementById("totalAmount");
        var selectedCurrency = currencySelect.value;
        var selectedTotalSum = ' . json_encode($currencyOptions) . '[selectedCurrency];
        totalAmount.textContent = "$" + (parseFloat(selectedTotalSum)).toFixed(2);
    }
</script>';
?>
                </div>
                </div>
                </div>

                </div>
                </div>
              </div>
              </div>
            </div>

            <div class="col-xl-12 col-xl-12">
                    <div class="row">
                      <div class="col-xl-12 col-xl-12">
                        <div class="card info-card sales-card">
                            <div class="card-header bg-light">Income & Expenditure</div>
                            <div class="card-body align-items-center">
                                <div class="row">
                  <div class="col-lg-5">
                      <h5 class="card-title" style="color: blue; font-weight:300; font-size: 13px;">TOTAL INCOME</h5>

                        <div class="d-flex">
                      <div class="ps-3">
                      <?php
$branchName = $_SESSION['branchName'];

$query = "SELECT currencySymbol, SUM(totalAmount) AS totalAmount FROM tblsales WHERE branchName = :branchName GROUP BY currencySymbol";
$myStatement = $dbConn->prepare($query);
$myStatement->bindParam(':branchName', $branchName);
$myStatement->execute();

$totalSales = array();
while ($row = $myStatement->fetch(PDO::FETCH_ASSOC)) {
    $currencySymbol = $row['currencySymbol'];
    $amount = str_replace(',', '', $row['totalAmount']);

    if (!isset($totalSales[$currencySymbol])) {
        $totalSales[$currencySymbol] = 0;
    }

    $totalSales[$currencySymbol] += (float)$amount;
}
$currencies = array_keys($totalSales);
?>

<div class="row">
    <div class="col-lg-5">
        <select id="currencySymbolFilter">
            <option value="USD" selected>USD</option>
            <?php foreach ($currencies as $currencySymbol) { ?>
                <?php if ($currencySymbol !== 'USD') { ?>
                    <option value="<?php echo $currencySymbol; ?>"><?php echo $currencySymbol; ?></option>
                <?php } ?>
            <?php } ?>
        </select>
    </div>
    <div class="col-lg-7">
        <div id="salesContainer">
            <?php
            foreach ($totalSales as $currencySymbol => $amount) {
                $displayStyle = ($currencySymbol === 'USD') ? 'block' : 'none';
                echo "<div class='salesItem' data-currency='$currencySymbol' style='display: $displayStyle;'>";
                echo "<h5 style='font-size:15px;'>" . number_format($amount, 2) . "</h5>";
                echo "</div>";
            }
            ?>
        </div>
    </div>
</div>

<script>
    var currencyFilterSelect = document.getElementById('currencySymbolFilter');
    var salesItems = document.getElementsByClassName('salesItem');

    currencyFilterSelect.addEventListener('change', function () {
        var selectedCurrency = this.value;

        for (var i = 0; i < salesItems.length; i++) {
            var item = salesItems[i];
            var itemCurrency = item.getAttribute('data-currency');

            if (selectedCurrency === 'all' || selectedCurrency === itemCurrency) {
                item.style.display = 'block';
            } else {
                item.style.display = 'none';
            }
        }
    });
</script>
                    </div>
                  </div>
                </div>
              <div class="col-lg-2"><br><br>
            <span style="border-right: 1px solid #000; height: 100px; padding: 20px;"></span>

          </div>
            <div class="col-lg-5 align-items-center">
                <h5 class="card-title" style="color: red; font-weight:300; font-size: 13px;">TOTAL EXPENSES</h5>

              <div class="d-flex">
                   <div class="ps-3">
                   <?php

$branchName = $_SESSION['branchName'];

$querySalaries = "SELECT currencySymbol, salaryAmount AS totalAmount FROM paymentsalaries WHERE branchName = :branchName";
$myStatement1 = $dbConn->prepare($querySalaries);
$myStatement1->bindParam(':branchName', $branchName);
$myStatement1->execute();

$totalExpenses = array();

while ($row = $myStatement1->fetch(PDO::FETCH_ASSOC)) {
    $currencySymbol = $row['currencySymbol'];
    $amount = str_replace(',', '', $row['totalAmount']);

    if (!isset($totalExpenses[$currencySymbol])) {
        $totalExpenses[$currencySymbol] = 0;
    }

    $totalExpenses[$currencySymbol] += (float)$amount;
}

$queryBills = "SELECT currencySymbol, amount AS totalAmount FROM paymentbills WHERE branchName = :branchName";
$myStatement2 = $dbConn->prepare($queryBills);
$myStatement2->bindParam(':branchName', $branchName);
$myStatement2->execute();

while ($row = $myStatement2->fetch(PDO::FETCH_ASSOC)) {
    $currencySymbol = $row['currencySymbol'];
    $amount = str_replace(',', '', $row['totalAmount']);

    if (!isset($totalExpenses[$currencySymbol])) {
        $totalExpenses[$currencySymbol] = 0;
    }

    $totalExpenses[$currencySymbol] += (float)$amount;
}

$currencies = array_keys($totalExpenses);
?>
<div class="row">
    <div class="col-lg-5">
        <select id="currencyFilter">
            <option value="USD" selected>USD</option>
            <?php foreach ($currencies as $currencySymbol) {
                if ($currencySymbol !== 'USD') { ?>
                    <option value="<?php echo $currencySymbol; ?>"><?php echo $currencySymbol; ?></option>
                <?php }
            } ?>
        </select>
    </div>
    <div class="col-lg-7">
        <div id="expensesContainer">
            <?php
            foreach ($totalExpenses as $currencySymbol => $amount) {
                $displayStyle = ($currencySymbol === 'USD') ? 'block' : 'none';

                echo "<div class='expenseItem' data-currency='$currencySymbol' style='display: $displayStyle;'>";
                echo "<h5 style='font-size:15px;'>" . number_format($amount, 2) . "</h5>";
                echo "</div>";
            }
            ?>
        </div>
    </div>
</div>

<script>
    var currencyFilterSelect = document.getElementById('currencyFilter');
    var expenseItems = document.getElementsByClassName('expenseItem');

    currencyFilterSelect.addEventListener('change', function () {
        var selectedCurrency = this.value;

        for (var i = 0; i < expenseItems.length; i++) {
            var item = expenseItems[i];
            var itemCurrency = item.getAttribute('data-currency');

            if (selectedCurrency === 'all' || selectedCurrency === itemCurrency) {
                item.style.display = 'block';
            } else {
                item.style.display = 'none';
            }
        }
    });
</script>
                    </div>
                  </div>
                  </div>
                </div>
                </div>
              </div>
              </div>
            </div>
 
          </div>
          </div>

      </div>
    </section>