<div class="card">
            <div class="card-body">
              <h5 class="card-title"><a href="new-quotation.php" class="btn btn-primary"><i class="bi bi-shield-plus me-1"></i> New Quotation</a></h5>
              <!-- Bordered Table -->
              <table class="table table-bordered datatable">
                <thead>
                  <tr>
                    <th scope="col">Quote Number</th>
                    <th scope="col">CustomerName</th>
                    <th scope="col">Quote Date</th>
                    <th scope="col">Action</th>
                  </tr>
                </thead>
                <tbody>
                <?php 
if ($_SESSION['roleName'] === 'Admin') {
    $sql = "SELECT * from quotation";
    $query = $dbConn->prepare($sql);
    $query->execute();
} else {
    $branchName = $_SESSION['branchName'];
    $sql = "SELECT * from quotation WHERE branchName = :branchName";
    $query = $dbConn->prepare($sql);
    $query->bindParam(':branchName', $branchName);
    $query->execute();
}

$results = $query->fetchAll(PDO::FETCH_OBJ);
$cnt = 1;

if ($query->rowCount() > 0) {
    foreach ($results as $result) {
        ?> 
        <tr>
            <td><?php echo $result->quoteNumber; ?></td>
            <td><?php echo $result->customerName; ?></td>
            <td><?php echo $result->quoteDate; ?></td>
            <td>
                <a href="sales-edit-quotation.php?id=<?php echo htmlentities($result->id); ?>" class="btn btn-primary"><i class="bi bi-pencil-square me-1"></i></a>
                <a href="preview-quotation.php?id=<?php echo htmlentities($result->id); ?>" class="btn btn-success"><i class="bi bi-eye me-1"></i></a>
                <a href="functions/quotation_actioning.php?del=<?php echo htmlentities($result->id); ?>" onclick="return confirm('Are you sure you want to Delete this Record?');" class="btn btn-danger"><i class="bi bi-trash"></i></a>
            </td>
        </tr>
        <?php $cnt = $cnt + 1;
    }
} else {
    ?>
    <tr>
        <td colspan="10">No Records Found!</td>
    </tr>
    <?php
}
?>
                  
                </tbody>
              </table>
              <!-- End Bordered Table -->

            </div>
          </div>
