<?php 
	class Dispatch {

		public $id;
		public $district;
		public $school;
		public $productStyle;
		public $serialNumber;
		public $item;
		public $description;
		public $size;
		public $quantity;
		public $created_on;
		public $updated_on;

		public $tableName = 'dispatch';
		public $dbConn;


		public function __construct($db) {
      		$this->dbConn = $db;
    	}

		public function getDispatchList() {
			$query = "SELECT * FROM " . $this->tableName;
      		// Prepare statement
      		$myStatement = $this->dbConn->prepare($query);

      		// Execute query
      		$myStatement->execute();
			return $myStatement;
		}

		public function getSingleRecordById() {

			$query = "SELECT * FROM " .$this->tableName . " WHERE id = :id LIMIT 1";

			$myStatement = $this->dbConn->prepare($query);

          	// Bind ID
          	$myStatement->bindParam(':id', $this->id);

          	// Execute query
          	$myStatement->execute();

          	$row = $myStatement->fetch(PDO::FETCH_ASSOC);

	          // Set properties
	          $this->district = $row['district'];
	          $this->school = $row['school'];
	          $this->productStyle = $row['productStyle'];
	          $this->serialNumber = $row['serialNumber'];
	          $this->item = $row['item'];
	          $this->description = $row['description'];
	          $this->size = $row['size'];
	          $this->quantity = $row['quantity'];         
		}
		
		public function addDispatch() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET district = :district, school = :school, productStyle = :productStyle, serialNumber = :serialNumber, item = :item, description = :description, size = :size, quantity = :quantity';

          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);

          	// Clean data
          	$this->district = htmlspecialchars(strip_tags($this->district));
          	$this->school = htmlspecialchars(strip_tags($this->school));
          	$this->productStyle = htmlspecialchars(strip_tags($this->productStyle));
          	$this->serialNumber = htmlspecialchars(strip_tags($this->serialNumber));
          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->size = htmlspecialchars(strip_tags($this->size));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));

          	// Bind data
          	$myStatement->bindParam(':district', $this->district);
          	$myStatement->bindParam(':school', $this->school);
          	$myStatement->bindParam(':productStyle', $this->productStyle);
          	$myStatement->bindParam(':serialNumber', $this->serialNumber);
          	$myStatement->bindParam(':item', $this->item);
			$myStatement->bindParam(':description', $this->description);
			$myStatement->bindParam(':size', $this->size);
			$myStatement->bindParam(':quantity', $this->quantity);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

		public function updateRecord() {
			
			$query = 'UPDATE ' . $this->tableName . ' SET district = :district, school = :school, productStyle = :productStyle, item = :item, description = :description, size = :size, quantity = :quantity WHERE id = :id';

          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);

          	// Clean data
          	$this->district = htmlspecialchars(strip_tags($this->district));
          	$this->school = htmlspecialchars(strip_tags($this->school));
          	$this->productStyle = htmlspecialchars(strip_tags($this->productStyle));
          	$this->item = htmlspecialchars(strip_tags($this->item));
          	$this->description = htmlspecialchars(strip_tags($this->description));
          	$this->size = htmlspecialchars(strip_tags($this->size));
          	$this->quantity = htmlspecialchars(strip_tags($this->quantity));
          	$this->id = htmlspecialchars(strip_tags($this->id));

          	// Bind data
			$myStatement->bindParam(':district', $this->district);
          	$myStatement->bindParam(':school', $this->school);
          	$myStatement->bindParam(':productStyle', $this->productStyle);
			$myStatement->bindParam(':item', $this->item);
			$myStatement->bindParam(':description', $this->description);
			$myStatement->bindParam(':size', $this->size);
			$myStatement->bindParam(':quantity', $this->quantity);
			$myStatement->bindParam(':id', $this->id);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

		public function deleteRecord() {
			$myStatement = $this->dbConn->prepare('DELETE FROM ' . $this->tableName . ' WHERE id = :id');
			$myStatement->bindParam(':id', $this->id);
			
			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}
	}
 ?>