// function to call results and display in modal
function showDetailedReport(id) {
    // make AJAX request to fetch data from server
    $.ajax({
      url: "reports/modal-results.php",
      type: "get",
      data: { id: id },
      success: function (response) {
        // set table rows with fetched data
        var rows = "";
        for (var i = 0; i < response.length; i++) {
          rows +=
            "<tr>" +
            "<td>" +
            (i + 1) +
            "</td>" +
            '<td><input type="text" class="form-control" name="itemName[]" value="' + response[i].itemName + '" readonly/></td>'+
            '<td><input type="text" class="form-control" name="unit_price[]" value="' + response[i].unit_price + '" readonly/></td>'+
            '<td><input type="text" class="form-control" name="quantity[]" value="' + response[i].quantity + '" readonly/></td>' +
            '<td><input type="text" class="form-control" name="amount[]" value="' + response[i].amount + '" readonly/></td>'+
            "</tr>";
        }
        // set table body with rows
        $("#modal-results tbody").html(rows);
        // set total amount
        $("#grandTotal").val(response[0].totalAmount);

        $("#saleDate").val(response[0].saleDate);
        // set currency
        $("#currencySymbol").val(response[0].currencySymbol);

        $("#amountPaid").val(response[0].amountPaid);

        $("#changeResult").val(response[0].changeResult);
      },

      error: function (xhr, _status, _error) {
        console.log(xhr.responseText);
      },
    });
    // show modal
    $("#detailedModal").modal("show");
  }

$(document).ready(function(){
    // define createTable() function outside the AJAX request
    function designTable(data) {
  
      var myTable = '';
  
      // check if data is defined and not an empty array
      if (data && data.length > 0) {
        // create a new row for each item in the data array
        for (var i = 0; i < data.length; i++) {
          myTable += '<tr class="item-row">';
          myTable += '<td>' + (i+1) + '</td>';
          myTable += '<td><input type="text" class="form-control" name="cashierName[]" value="' + data[i].cashierName + '" readonly/></td>';
          myTable += '<td><input type="text" class="form-control" name="totalAmount[]" required value="' + data[i].totalAmount + '" readonly/></td>';
          myTable += '<td><input type="text" class="form-control" name="currency[]" readonly value="' + data[i].currencySymbol + '" readonly/></td>';
          myTable += '<td><button class="btn btn-primary" type="button" onclick="showDetailedReport(' + data[i].id + ')" style="font-size:12px"><i class="bi bi-eye me-1" ></i>Full Report</button></td>';
          myTable += '</tr>';
      
          const saveToPDFButton = document.getElementById('saveDetailedReportPDF');
      
          saveToPDFButton.disabled = false;
        }
      }
       else {
        // handle case when data is not defined or empty
        alert('No results found....!.');
  
        const saveToPDFButton = document.getElementById('saveDetailedReportPDF');
        saveToPDFButton.disabled = true;
  
      }
  
      return myTable;
    }
    $('#detailedReport').submit(function(e){
      e.preventDefault();
  
      var formData = new FormData($(this)[0]);
  
      $.ajax({
        url: 'reports/detailed_report_results.php',
        type: 'POST',
        data: formData,
        dataType: 'json', // Set the response datatype to JSON
        success: function (jsonData) {
          console.log('JSON Data:', jsonData);
  
          $('#totalAmount').val(jsonData.totalAmount);
  
          // call createTable() with jsonData.results
          var myTable = designTable(jsonData.results);
  
          $('#detailedReportResults').html(myTable);
  
        },
        error: function(_xhr, _status, error) {
          console.log("Error: " + error);
          $('#detailedReportResults tbody').empty();
        },
        cache: false,
        contentType: false,
        processData: false
      });
    });
      
  });
  