<?php
//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include("../includes/DbConnect.php");

if(isset($_POST['saleDate']) && isset($_POST['cashierName']) && isset($_POST['currencySymbol'])) {
  $currencySymbol = $_POST['currencySymbol'];
  $saleDate = $_POST['saleDate'];
  $cashierName = $_POST['cashierName'];
  
  $sql = "SELECT *
            FROM tblsales
            WHERE currencySymbol = :currencySymbol
            AND saleDate = :saleDate
            AND cashierName = :cashierName";
    $stmt = $dbConn->prepare($sql);
    $stmt->execute([
      ':currencySymbol' => $currencySymbol,
      ':saleDate' => $saleDate,
      ':cashierName' => $cashierName
    ]);

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    header("Content-Type: application/json");

  if (empty($rows)) {
    echo json_encode(array(
      "error" => "Failed to retrieve sales data"
    ));
  } else {
    //$totalAmount = 0;
    $results = [];
    
    foreach ($rows as $row) {
        //$totalAmount += $row['amount'];
        $results[] = array(
          "id" => $row['id'],
          "cashierName" => $row['cashierName'],
          "totalAmount" => $row['totalAmount'],
          "currencySymbol" => $row['currencySymbol']
        );
    }
    
    // Return data as JSON
    echo json_encode(array(
      "results" => $results
      //"totalAmount" => $totalAmount
    ));    
  }
}
