$(document).ready(function() {
    $('#generateNetprofitReport').on('submit', function(e) {
      e.preventDefault();
  
      var startDate = $('#startDate').val();
      var endDate = $('#endDate').val();
      var cashierName = $('#cashierNameNetProfit').val();
      var currency = $('#currencyNetProfit').val();
  
      $.ajax({
        type: 'POST',
        url: 'reports/get-net-profit.php',
        data: { startDate: startDate, endDate: endDate, cashierName: cashierName, currency: currency },
        success: function(data) {
          console.log(data); // check the data object
          var table = '<table><thead><tr><th>ID</th><th>Item Name</th><th>Total Quantity</th><th>Total Price</th></tr></thead><tbody>' + data.htmlRows + '</tbody></table>';
          $('#netProfitResults').html(table);
          if (data.totalAmount && data.totalCost && data.netProfit) {
            $('#totalAmount').text(currency + data.totalAmount.toFixed(2));
            $('#totalCost').text(currency + data.totalCost.toFixed(2));
            $('#netProfit').text(currency + data.netProfit.toFixed(2));
  
            $('#saveToPDFButton').prop('disabled', false);
          } else {
            console.log('Missing properties in data object');
          }
        }      
      });
    });
  });


  <?php
error_reporting(E_ALL);
include("../includes/DbConnect.php");

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        $startDate = date('Y-m-d', strtotime($_POST['startDate']));
        $endDate = date('Y-m-d', strtotime($_POST['endDate']));
        $cashierName = $_POST['cashierName'];
        $currency = $_POST['currency'];

        // Retrieve sales data within date range and by cashier name
        $query = "SELECT i.id, s.itemName, SUM(s.quantity) as totalQuantity, SUM(s.unit_price * s.quantity) as totalPrice, SUM(s.cost_price * s.quantity) as totalCost FROM tblsale_items s INNER JOIN tblsales i ON s.id = i.id WHERE i.saleDate BETWEEN :startDate AND :endDate AND i.cashierName = :cashierName AND i.currency = :currency GROUP BY i.id";
        $myStatement = $dbConn->prepare($query);
        $myStatement->bindParam(':startDate', $startDate);
        $myStatement->bindParam(':endDate', $endDate);
        $myStatement->bindParam(':cashierName', $cashierName);
        $myStatement->bindParam(':currency', $currency);
        $myStatement->execute();
        $results = $myStatement->fetchAll(PDO::FETCH_OBJ);

        $totalAmount = 0;
        $totalCost = 0;

        // Generate HTML table rows for sales data
        $htmlRows = '';
        foreach ($results as $result) {
            $totalAmount += $result->totalPrice;
            $totalCost += $result->totalCost;

            $htmlRows .= '<tr>';
            $htmlRows .= '<td>'. $result->id .'</td>';
            $htmlRows .= '<td>'. $result->itemName .'</td>';
            $htmlRows .= '<td>'. $result->totalQuantity .'</td>';
            $htmlRows .= '<td>'. $currency . number_format($result->totalPrice, 2) .'</td>';
            $htmlRows .= '</tr>';
        }

        $netProfit = $totalAmount - $totalCost;
        $data = array(
            'htmlRows' => $htmlRows,
            'totalAmount' => $totalAmount,
            'totalCost' => $totalCost,
            'netProfit' => $netProfit
        );

        echo json_encode($data);
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>