<?php 
	class PaymentsBills {

          public $paymentMode;
          public $currency;
          public $chartOfAccounts;
		public $billType;
		public $branch;
		public $accountName;
		public $accountNumber;
          public $amount;
		public $memo;
		public $paymentDate;

		public $tableName = 'paymentbills';
		public $dbConn;

		public function __construct($db) {
      		$this->dbConn = $db;
    	}
		
		public function addBill() {
			$query = 'INSERT INTO ' . $this->tableName . ' SET paymentMode = :paymentMode, currency = :currency, chartOfAccounts = :chartOfAccounts, billType = :billType, branch = :branch, accountName = :accountName, accountNumber = :accountNumber, amount = :amount, memo = :memo, paymentDate = :paymentDate';
          	// Prepare statement
          	$myStatement = $this->dbConn->prepare($query);
          	// Clean data
          	$this->paymentMode = htmlspecialchars(strip_tags($this->paymentMode));
          	$this->chartOfAccounts = htmlspecialchars(strip_tags($this->chartOfAccounts));
               $this->currency = htmlspecialchars(strip_tags($this->currency));
          	$this->billType = htmlspecialchars(strip_tags($this->billType));
          	$this->branch = htmlspecialchars(strip_tags($this->branch));
          	$this->accountName = htmlspecialchars(strip_tags($this->accountName));
          	$this->accountNumber = htmlspecialchars(strip_tags($this->accountNumber));
          	$this->amount = htmlspecialchars(strip_tags($this->amount));
          	$this->memo = htmlspecialchars(strip_tags($this->memo));
          	$this->paymentDate = htmlspecialchars(strip_tags($this->paymentDate));

          	// Bind data
          	$myStatement->bindParam(':paymentMode', $this->paymentMode);
          	$myStatement->bindParam(':chartOfAccounts', $this->chartOfAccounts);
               $myStatement->bindParam(':currency', $this->currency);
          	$myStatement->bindParam(':billType', $this->billType);
          	$myStatement->bindParam(':branch', $this->branch);
          	$myStatement->bindParam(':accountName', $this->accountName);
          	$myStatement->bindParam(':accountNumber', $this->accountNumber);
          	$myStatement->bindParam(':amount', $this->amount);
          	$myStatement->bindParam(':memo', $this->memo);
          	$myStatement->bindParam(':paymentDate', $this->paymentDate);

			if($myStatement->execute()) {
				return true;
			} else {
				return false;
			}
		}

	}
 ?>