<?php
    if(isset($_POST['addSale'])) {
    // Retrieve the current stock level for each item being sold
    $stockLevels = array();
    foreach ($_POST['itemName'] as $key => $item) {
        $myStatement = $dbConn->prepare("SELECT stock_level FROM tblpos_stock WHERE itemName = :itemName");
        $myStatement->bindParam(':itemName', $item);
        $myStatement->execute();
        $result = $myStatement->fetch(PDO::FETCH_ASSOC);
        $stockLevels[$item] = $result['stock_level'];
    }
    
    // Insert the sale record into the database
    $myStatement = $dbConn->prepare("INSERT INTO tblsales (cashierName, branchCode, totalAmount, currency, amountPaid, changeResult, remarks, saleDate) VALUES (:cashierName, :branchCode, :totalAmount, :currency, :amountPaid, :changeResult, :remarks, :saleDate)");
    $myStatement->bindParam(':cashierName', $_POST['cashierName']);
    $myStatement->bindParam(':branchCode', $_POST['branchCode']);
    $myStatement->bindParam(':totalAmount', $_POST['totalAmount']);
    $myStatement->bindParam(':currency', $_POST['currency']);
    $myStatement->bindParam(':amountPaid', $_POST['amountPaid']);
    $myStatement->bindParam(':changeResult', $_POST['changeResult']);
    $myStatement->bindParam(':remarks', $_POST['remarks']);
    $myStatement->bindParam(':saleDate', $_POST['saleDate']);
    $myStatement->execute();
    
    $sale_id = $dbConn->lastInsertId();
    
    // Update the stock level for each item being sold
    if ($sale_id) {
        if (is_array($_POST['itemName'])) {
            foreach ($_POST['itemName'] as $key => $item) {
                $quantitySold = $_POST['quantity'][$key];
                $newStockLevel = $stockLevels[$item] - $quantitySold;
                
                $myStatement = $dbConn->prepare("UPDATE tblpos_stock SET stock_level = :newStockLevel WHERE itemName = :itemName");
                $myStatement->bindParam(':newStockLevel', $newStockLevel);
                $myStatement->bindParam(':itemName', $item);
                $myStatement->execute();
                
                $myStatement = $dbConn->prepare("INSERT INTO tblsale_items (sale_id, itemName, unit_price, cost_price, quantity, amount) VALUES (:sale_id, :itemName, :unit_price, :cost_price, :quantity, :amount)");
                $myStatement->bindParam(':sale_id', $sale_id);
                $myStatement->bindParam(':itemName', $item);
                $myStatement->bindParam(':unit_price', $_POST['unit_price'][$key]);
                $myStatement->bindParam(':cost_price', $_POST['cost_price'][$key]);
                $myStatement->bindParam(':quantity', $quantitySold);
                $myStatement->bindParam(':amount', $_POST['amount'][$key]);
                $myStatement->execute();
            }
        } 
        echo '<script>alert("Sale record was added Successfully...");</script>';
        echo '<script>window.location.replace("add-sale.php")</script>';
    } else {
        echo '<script>alert("Something went wrong...");</script>';
    }
  }
?>